﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using WpfApp1.Structure;
using WpfApp1.Tools;
using static System.Formats.Asn1.AsnWriter;
using System.Xml.Linq;
//using Emgu.CV.Structure;
using Emgu.CV;
using Emgu.CV.Util;
using Emgu.CV.CvEnum;
//using System.Drawing;
using Microsoft.Win32;
using System.IO;
using System.Text.Json;
using System.Windows.Media.Media3D;
using System.Diagnostics;
using System.Security.Cryptography.Xml;
using System.Windows.Controls.Primitives;
using static Emgu.Util.Platform;
using static System.Net.Mime.MediaTypeNames;
using System.Windows.Threading;
using System.Collections.ObjectModel;
using PDollarGestureRecognizer;
using Emgu.CV.Features2D;

namespace WpfApp1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private int Stroke_id = -1;
        private int Symbol_id = -1;
        private Dictionary<int, Stroke> d_idStroke = new Dictionary<int, Stroke>();
        private Dictionary<int, Symbol> d_idSymbol = new Dictionary<int, Symbol>();
        private Dictionary<Stroke, Symbol> d_StrokeSymbol = new Dictionary<Stroke, Symbol>();
        public List<Symbol> currentSymbols = new List<Symbol>();
        private List<Symbol> markedSymbols = new List<Symbol>();
        private List<Symbol> shadowSymbols = new List<Symbol>();
        private StrokeCollection shadowStrokes = new StrokeCollection();
        private bool useShadowSymbol = true;
        private int i_shadowHistory = -1;
        private bool useHistory = true;
        private List<History> undoHistories = new List<History>();
        private List<History> redoHistories = new List<History>();
        private ObservableCollection<ListItem> NodeItems { get; set; }
        private ObservableCollection<ListItem> EdgeItems { get; set; }

        //private Symbol selectedSymbol = null;
        private Rect previousSelectionBounds;
        private Symbol previousSelectedSymbol = null;
        private bool hide_left = false;
        private bool hide_right = false;
        private List<Symbol> tsymbols1 = new List<Symbol>();
        private List<Symbol> tsymbols2 = new List<Symbol>();

        private List<string> nodeClassList = new List<string> { "Terminal", "Process", "Decision", "Manual Input", "Database", "Ellipse" };
        private List<string> edgeClassList = new List<string> { "Arrow" };
        private List<string> opList = new List<string> { "add", "delete", "change", "select", "move", "set" };
        private List<string> sbList = new List<string> { "node", "edge" };

        private System.Windows.Point? startPoint = null;
        private object draggedItem = null;
        private Gesture[] gestureSet = null;
        string basePath = "D:\\Project\\GPH\\WpfApp1\\WpfApp1\\";

        public List<Symbol> GetCurrentSymbol()
        {
            return currentSymbols;
        }

        private void WindowLoaded(object sender, RoutedEventArgs e)
        {
            SymbolTemplate.GetSymbolTemplates(basePath + "Templates\\", video_text);
            GptTools.GetApi();

            NodeItems = new ObservableCollection<ListItem>
            {
                new ListItem("id", ""),
                new ListItem("text", ""),
                new ListItem ("class", ""),
                new ListItem ("color", ""),
                new ListItem ("area", ""),
                new ListItem ("edges_in"),
                new ListItem ("edges_out")
            };
            EdgeItems = new ObservableCollection<ListItem>
            {
                new ListItem ("id", ""),
                new ListItem ("text", ""),
                new ListItem ("class", ""),
                new ListItem ("color", ""),
                new ListItem ("weight", ""),
                new ListItem ("nodes_from"),
                new ListItem ("nodes_to")
            };
            lv_node.ItemsSource = NodeItems;
            lv_edge.ItemsSource = EdgeItems;

            foreach (string op in opList)
            {
                OpListBox.Items.Add(new ListBoxItem { Content = op, Tag = op });
            }
            foreach (string sb in sbList)
            {
                SbListBox.Items.Add(new ListBoxItem { Content = sb, Tag = sb });
            }

            gestureSet = LoadGestureSet(basePath + "GestureSet\\");

            useShadowSymbol = false;
            string json = File.ReadAllText(basePath + "nodes.json", Encoding.UTF8);
            //LoadJson(json);

            //for (int i = 1; i < 5; i++)
            //{
            //    for (int j = 1; j < 5; j++)
            //    {
            //        StylusPointCollection stylusPoints = new StylusPointCollection
            //        {
            //            new StylusPoint(100 * i, 100),
            //            new StylusPoint(100 * j, 200)
            //        };
            //        Stroke stroke = new Stroke(stylusPoints);
            //        video_sketch.Strokes.Add(stroke);
            //    }
            //}

            Matrix matrix = new Matrix();
            matrix.ScaleAt(0.8, 0.8, 0, 0);
            video_sketch.Strokes.Transform(matrix, false);
            //foreach (Symbol symbol in currentSymbols)
            //{
            //    symbol.Resized();
            //    symbol.RefreshTextBox();
            //}
            useShadowSymbol = true;

            int[] idl = new int[] { 0, 1, 2, 4, 11, 12, 13,  };
            foreach (Stroke stroke in video_sketch.Strokes)
            {
                if (!d_StrokeSymbol.ContainsKey(stroke))
                {
                    continue;
                }
                if (idl.Contains(d_StrokeSymbol[stroke].id))
                {
                    //continue;
                }
                if (d_StrokeSymbol[stroke] is Edge && d_StrokeSymbol[stroke].strokes[0] != stroke)
                {
                    continue;
                }
                //stroke.StylusPoints = ApplyHandDrawnStyle(stroke.StylusPoints);
            }

            //Edge te = AddEdgeBetweenNodes(d_idSymbol[0] as Node, d_idSymbol[4] as Node);
            //StrokeCollection strokes = new StrokeCollection();
            //bool tb = true;
            //foreach (Stroke stroke in te.strokes)
            //{
            //    stroke.DrawingAttributes.Color = SymbolColor.d_Colors["gray"];
            //    if (!tb)
            //    {
            //        strokes.Add(stroke);
            //        continue;
            //    }
            //    tb = false;
            //    strokes.Add(CreateDashedStrokes(stroke));
            //}
            //video_sketch.Strokes.Remove(te.strokes);
            //te.strokes = strokes;
            //video_sketch.Strokes.Add(te.strokes);

            //foreach (Stroke stroke in video_sketch.Strokes)
            //{
            //    stroke.DrawingAttributes.Color = Colors.Black;
            //}

            
        }
    }
}